/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.udf.LayoutProducerUDF;
import DE.siemens.ad.udf.LogoComfortUDF;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockFigure;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.UDFEditorInfo;
import DE.siemens.ad.udf.UDFFactory;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.io.File;
import java.util.Vector;

public class NewDrawingFromUDFAction
extends LogoAction {
    private static final long serialVersionUID = 7861848384971259229L;
    private UDFBlock udfBlock = null;

    public NewDrawingFromUDFAction() {
        this.putValue("Name", "create udf from udf block");
        this.putValue("textKey", "pdraw.standard.loadToFigure");
        this.putValue("SmallIcon", Global.getIcon("CreateUDF.gif"));
        this.putValue("ShortDescription", Language.getStringNoTilde("pdraw.standard.loadToFigure", "Expand UDF"));
        this.disabledContextVector = new Vector(2);
        this.disabledContextVector.add(SimulationTool.class);
        this.disabledContextVector.add(OnlineTestTool.class);
    }

    public boolean doIt() {
        BlockConnector obc;
        Object bclist;
        int i;
        ConstantBlock block;
        int signalType;
        int i2;
        if (this.udfBlock != null && UDFFactory.instance().getUDFBlockState(this.udfBlock.getGuid()) == 0) {
            Application.getInstance().loadDocument(new File(UDFFactory.instance().getUDFFilePath(this.udfBlock.getGuid())));
            return true;
        }
        if (!Util.isEmptyString(this.udfBlock.getPassword()) && !this.verifyPassword(this.udfBlock.getIdentifier(), this.udfBlock.getPassword())) {
            return false;
        }
        View view = Application.getInstance().createView(new UDFEditorInfo().getEditorClassName());
        Application.getInstance().addDocument(view);
        LogoDrawingUDF macroDrawing = (LogoDrawingUDF)((LogoDrawingView)view).drawing();
        LogoComfortUDF editor = (LogoComfortUDF)view.getEditor();
        WiringDiagramUDF wd = (WiringDiagramUDF)macroDrawing.getWiringDiagram();
        for (i2 = 0; i2 < this.udfBlock.getBlocks().size(); ++i2) {
            wd.insert(this.udfBlock.getBlocks().get(i2));
        }
        for (i2 = 0; i2 < this.udfBlock.getInConnectorCount() - 1; ++i2) {
            signalType = this.udfBlock.getInputDeputy(i2).getOutConnector(0).getSignalType();
            block = null;
            if (signalType == 0) {
                block = new InputBlock(wd);
            } else if (signalType == 1) {
                block = new AnalogInputBlock(wd);
            }
            block.setUserDefinedName(this.udfBlock.getInputDeputy(i2).getUserDefinedName());
            wd.getInConnectorBlocks().add(block);
            wd.insert(block);
        }
        for (i2 = 0; i2 < this.udfBlock.getOutConnectorCount(); ++i2) {
            signalType = this.udfBlock.getOutputDeputy(i2).getInConnector(0).getSignalType();
            block = null;
            block = signalType == 0 ? new OutputBlock(wd) : new AnalogOutputBlock(wd);
            block.setUserDefinedName(this.udfBlock.getOutputDeputy(i2).getUserDefinedName());
            wd.getOutConnectorBlocks().add(block);
            wd.insert(block);
        }
        UDFBlock newUdfBlock = wd.getUDFBlock();
        newUdfBlock.setIdentifier(this.udfBlock.getIdentifier());
        newUdfBlock.setUDFBlockParameter((UDFBlockParameter)this.udfBlock.getParameter());
        newUdfBlock.initInConnectors4EditMode(wd.getInConnectorBlocks());
        newUdfBlock.initOutConnectors4EditMode(wd.getOutConnectorBlocks());
        newUdfBlock.setPassword(this.udfBlock.getPassword());
        newUdfBlock.setEncryptedPassword(this.udfBlock.getEncryptedPassword());
        for (i = 0; i < this.udfBlock.getInConnectorCount() - 1; ++i) {
            bclist = this.udfBlock.getInputDeputy(i).getOutConnector(0).getLinkedConnectors();
            obc = wd.getInConnectorBlocks().get(i).getOutConnector(0);
            while (bclist.hasMoreElements()) {
                InBlockConnector in = bclist.nextElement();
                ((OutBlockConnector)obc).connect(in);
            }
            InBlockConnectorEnumeration connectors = this.udfBlock.getInputDeputy(i).getOutConnector(0).getLinkedConnectors();
            while (connectors.hasMoreElements()) {
                connectors.nextElement().disconnect(this.udfBlock.getInputDeputy(i).getOutConnector(0));
            }
            this.udfBlock.getInputDeputy(i).getOutConnector(0).disconnectAll();
        }
        for (i = 0; i < this.udfBlock.getOutConnectorCount(); ++i) {
            bclist = this.udfBlock.getOutputDeputy(i).getInConnector(0).getLinkedConnectors();
            obc = wd.getOutConnectorBlocks().get(i).getInConnector(0);
            while (bclist.hasMoreElements()) {
                OutBlockConnector out = bclist.nextElement();
                ((InBlockConnector)obc).connect(out);
            }
            this.udfBlock.getOutputDeputy(i).getInConnector(0).disconnectAll();
        }
        for (i = 0; i < wd.getBlocks().size(); ++i) {
            Block blk = (Block)wd.getBlocks().get(i);
            if (!(blk instanceof UDFBlock) || blk.getNumber() <= wd.getHardware().getMaxResource(25)) continue;
            blk.changeNumber(blk.getNumber() - wd.getHardware().getMaxResource(25));
        }
        LayoutProducerUDF layoutProducer = new LayoutProducerUDF((DrawingView)((Object)view), wd.getBlocks());
        layoutProducer.layout();
        editor.getActionManager().deleteUndoBuffer();
        return true;
    }

    private boolean verifyPassword(String path, String password) {
        LogoComfortUDF.UDFPasswordPanel panel = new LogoComfortUDF.UDFPasswordPanel(path, password);
        SplittedDlg dlg = SplittedDlg.create(null, panel, 3);
        dlg.setTitle(Language.getString("dialog.info.udf.password.confirm.title", "UDF password"));
        dlg.show();
        return dlg.getControlPanel().getResult() == 1;
    }

    public boolean prepareAction() {
        super.prepareAction();
        this.udfBlock = null;
        LogoDrawingView currentView = (LogoDrawingView)((LogoComfort)this.getOwner()).view();
        Vector vector = currentView.selection();
        if (vector.size() == 1 && vector.get(0) instanceof UDFBlockFigure) {
            UDFBlock srcUDFBlock = (UDFBlock)((UDFBlockFigure)vector.get(0)).getBlock();
            if (srcUDFBlock.getSourceLocateFlag() == 0 || srcUDFBlock.getSourceLocateFlag() != 0 && UDFFactory.instance().getUDFBlockState(srcUDFBlock.getGuid()) != 0) {
                this.udfBlock = (UDFBlock)srcUDFBlock.deepCopy();
            } else if (srcUDFBlock.getState() == 0) {
                this.udfBlock = UDFFactory.instance().getUDFBlock(((LogoDrawing)currentView.drawing()).getWiringDiagram(), srcUDFBlock.getGuid());
            }
            return true;
        }
        return false;
    }
}

